//
// Preferences.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the Preferences class
//
#include "Preferences.h"
#include "xvgopher.h"
#include <stdlib.h>
#include <fstream.h>
#include <xview/xview.h>
#include <xview/defaults.h>


//***************************************************************************
// Preferences::Preferences()
//
Preferences::Preferences()
{
	//
	// Get the path to the .xvgopher-defaults file in the user's home directory
	//
	char		*home = getenv("HOME");
	if (!home)
		home = ".";
	char		filename[100];
	sprintf(filename, "%s/.xvgopher-defaults", home);

	//
	// Read in any values from it
	//
	defaults_load_db(filename);

	//
	// Now get the values we are interested in.
	//
	remove_children = defaults_get_boolean("xvgopher.removeclients", "XvGopher.RemoveClients", FALSE);
	popup_bookmarks = defaults_get_boolean("xvgopher.popupbookmarks", "XvGopher.PopupBookmarks", FALSE);
	mail_filter = strdup(defaults_get_string("xvgopher.mailfilter", "XvGopher.MailFilter", DEFAULT_MAILER));
	print_filter = strdup(defaults_get_string("xvgopher.printfilter", "XvGopher.PrintFilter", DEFAULT_PRINT_FILTER));
	play_filter = strdup(defaults_get_string("xvgopher.playfilter", "XvGopher.PlayFilter", DEFAULT_PLAYER));
	image_filter = strdup(defaults_get_string("xvgopher.imagefilter", "XvGopher.ImageFilter", DEFAULT_IMAGER));
	telnet_command = strdup(defaults_get_string("xvgopher.telnetcommand", "XvGopher.TelnetCommand", DEFAULT_TELNET));
}


//***************************************************************************
// Preferences::~Preferences()
//
Preferences::~Preferences()
{
	//
	// Get the path to the .xvgopher-defaults file in the user's home directory
	//
	char		*home = getenv("HOME");
	if (!home)
		home = ".";
	char		filename[100];
	sprintf(filename, "%s/.xvgopher-defaults", home);

	ofstream	out(filename);
	if (out.fail())
		return;

	static char *truth[2] = {"False", "True"};

	//
	// Write the things we know about to the file
	//
	out << "XvGopher.RemoveClients:\t" << truth[remove_children] << "\n";
	out << "XvGopher.PopupBookmarks:\t" << truth[popup_bookmarks] << "\n";
	out << "XvGopher.MailFilter:\t" << mail_filter << "\n";
	out << "XvGopher.PrintFilter:\t" << print_filter << "\n";
	out << "XvGopher.PlayFilter:\t" << play_filter << "\n";
	out << "XvGopher.ImageFilter:\t" << image_filter << "\n";
	out << "XvGopher.TelnetCommand:\t" << telnet_command << "\n";
	out.close();

	//
	// For good measures, we should delete the storage used by the preferences
	//
	delete mail_filter;
	delete print_filter;
	delete play_filter;
	delete image_filter;
	delete telnet_command;
}


//***************************************************************************
// int Preferences::get_remove_children()
//
int Preferences::get_remove_children()
{
	return remove_children;
}


//***************************************************************************
// void Preferences::set_remove_children(int x)
//
void Preferences::set_remove_children(int x)
{
	 remove_children = x != 0;
}


//***************************************************************************
// int Preferences::get_popup_bookmarks()
//
int Preferences::get_popup_bookmarks()
{
	return popup_bookmarks;
}


//***************************************************************************
// void Preferences::set_popup_bookmarks(int x)
//
void Preferences::set_popup_bookmarks(int x)
{
	 popup_bookmarks = x != 0;
}


//***************************************************************************
// char *Preferences::get_mail_filter()
//
char *Preferences::get_mail_filter()
{
	return mail_filter;
}


//***************************************************************************
// void Preferences::set_mail_filter(char *s)
//
void Preferences::set_mail_filter(char *s)
{
	delete mail_filter;
	 mail_filter = strdup(s);
}


//***************************************************************************
// char *Preferences::get_print_filter()
//
char *Preferences::get_print_filter()
{
	return print_filter;
}


//***************************************************************************
// void Preferences::set_print_filter(char *s)
//
void Preferences::set_print_filter(char *s)
{
	delete print_filter;
	 print_filter = strdup(s);
}


//***************************************************************************
// char *Preferences::get_play_filter()
//
char *Preferences::get_play_filter()
{
	return play_filter;
}


//***************************************************************************
// void Preferences::set_play_filter(char *s)
//
void Preferences::set_play_filter(char *s)
{
	delete play_filter;
	 play_filter = strdup(s);
}


//***************************************************************************
// char *Preferences::get_image_filter()
//
char *Preferences::get_image_filter()
{
	return image_filter;
}


//***************************************************************************
// void Preferences::set_image_filter(char *s)
//
void Preferences::set_image_filter(char *s)
{
	delete image_filter;
	 image_filter = strdup(s);
}


//***************************************************************************
// char *Preferences::get_telnet_command()
//
char *Preferences::get_telnet_command()
{
	return telnet_command;
}


//***************************************************************************
// void Preferences::set_telnet_command(char *s)
//
void Preferences::set_telnet_command(char *s)
{
	delete telnet_command;
	telnet_command = strdup(s);
}


