//
// Object.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This baseclass defines how an object should behave.
// This includes the ability to be put into a list
//
#ifndef	_Object_h_
#define	_Object_h_

class Object
{
public:
	//
	// Constructor/Destructor
	//
							Object();
	virtual					~Object();

	//
	// Member access
	//
	Object					*Next();
	void					Next(Object *obj);
	Object					*Previous();
	void					Previous(Object *obj);

protected:
	Object					*next;
	Object					*prev;
};


//***************************************************************************
// Object::Object()
// PURPOSE:
//    This is the simple constructor
//
inline Object::Object()
{
	next = prev = (Object *) 0;
}

//***************************************************************************
// Object::~Object()
// PURPOSE:
//    This is the simple destructor
//
inline Object::~Object()
{
	next = prev = (Object *) 0;
}


//***************************************************************************
// inline void Object::Next(Object *obj)
// PURPOSE:
//    Assign the next value
//
inline void Object::Next(Object *obj)
{
	next = obj;
}


//***************************************************************************
// inline void Object::Previous(Object *obj)
// PURPOSE:
//    Assign the previous value
//
inline void Object::Previous(Object *obj)
{
	prev = obj;
}


//***************************************************************************
// inline Object *Object::Next()
// PURPOSE:
//    Get the next value
//
inline Object *Object::Next()
{
	return next;
}


//***************************************************************************
// inline Object *Object::Next()
// PURPOSE:
//    Get the previous value
//
inline Object *Object::Previous()
{
	return prev;
}


#endif	_Object_h_
