//
// List.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class implements a linked list of objects.  It itself is also an
// object
//
#ifndef	_List_h_
#define	_List_h_

#include "Object.h"

class List : public Object
{
public:
	//
	// Constructors/Destructor
	//
							List();
//							List(List &list);
	virtual					~List();

	//
	// List access
	//
	void					add(Object *obj);
	void					detach(Object *obj);

	//
	// List traversal
	//
	void					start_get();
	Object					*get_next();

protected:
	//
	// These variables are to keep track of the linked list
	//
	Object					*first;
	Object					*last;
	Object					*current;

	int						size;
};

#endif	_List_h_
