//
// List.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the List class
//
#include "List.h"

#define	NULL	((void *) 0)


//***************************************************************************
// List::List()
//
List::List()
{
	first = last = current = (Object *) 0;
	size = 0;
}


//***************************************************************************
// List::~List()
//
List::~List()
{
	if (first)
	{
		Object	*obj;
		start_get();
		while (obj = get_next())
		{
			delete obj;
		}
	}
}


//***************************************************************************
// void List::add(Object *obj)
// PURPOSE:
//    Add an object to the list.  The adding will be done at the end of the
//    list.
void List::add(Object *obj)
{
	if (!first)
	{
		//
		// The list is empty.  Easy!  Just put the object in it.
		//
		first = last = obj;
		obj->Next((Object *) 0);
		obj->Previous((Object *) 0);
	}
	else
	{
		//
		// There is something already in the list.  Just append it
		//
		last->Next(obj);
		obj->Previous(last);
		obj->Next((Object *) 0);
		last = obj;
	}
	size++;
}


//***************************************************************************
// void List::start_get()
// PURPOSE:
//    Prepare the list for itteration.  This needs to be called so that
//    get_next() will return the first element of the list
//
void List::start_get()
{
	current = first;
}


//***************************************************************************
// Object *List::get_next()
// PURPOSE:
//    Return the next object in the list
//
Object *List::get_next()
{
	if (current)
	{
		Object	*temp = current;
		current = current->Next();
		return temp;
	}
	else
		return (Object *) 0;
}

