//
// Gopher.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class implements an interface to a gopher server
//
#ifndef	_Gopher_h_
#define	_Gopher_h_

#include "List.h"

//
// The following defines are used to determine what kind of data the
// server is providing
//

class Gopher
{
public:
	//
	// Constructors/Destructor
	//
							Gopher(class GWindow *gwin);
							Gopher(char *server, int port, class GWindow *gwin);
							~Gopher();

	int						open(char *server, int port);

	//
	// Data retrieval
	//
	int						read(char type, char *str);
	void					start_get();
	char					*get_next();
	void					read_list();
	void					read_ascii();
	void					read_binary();

	//
	// Data types can be of several types.  The data types determine
	// where the actual data is kept.
	//
	typedef enum
	{
		TYPE_LIST,
		TYPE_ASCII,
		TYPE_BINARY,
		TYPE_SOUND,
		TYPE_IMAGE,
	} DataType;

	//
	// To let others know what kind of data we are looking at we
	// have the following variable:
	//
	DataType				datatype;

	char					filename[100];

private:
	class Connection		*connection;	// Connection with gopher server
	class GWindow			*gwindow;		// The window that belongs to us

	List					list;
	int						fd;
	int						length;			// To keep track of file size

	//
	// Callback routines.  (They need to be static!!!)
	//
	static void				read_list_proc(Gopher *gopher, int fd);
	static void				read_ascii_proc(Gopher *gopher, int fd);
	static void				read_binary_proc(Gopher *gopher, int fd);
};

#endif	_Gopher_h_
