//
// GWindow.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// The Window class does everything that needs to be done concerning
// gopher and XView.
//
#ifndef	_GWindow_h_
#define	_GWindow_h_

#include "Gopher.h"
#include "Response.h"
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/textsw.h>

#define	WINDOW_WIDTH		536
#define	WINDOW_HEIGHT		332

class GWindow
{
public:
	//
	// Constructors/Destructors
	//
							GWindow();
							~GWindow();

	//
	// Different ways of opening new windows
	//
	friend GWindow			*CreateWindow(Response *resp, Frame parent = NULL);
	virtual int				open(Response *resp);

	//
	// These are callbacks which are to notify us of finished business.
	//

	//
	// The program's main loop is actuall in this class
	//
	void					main_loop();

	virtual void			display();
	void					status(char *str);

	//
	// Some notifications
	//
	void					nothing_found();
	void					list_full();

protected:
	//
	// We need to remember things about the windows:
	//
	Frame					frame;
	Panel					panel;
	Frame					parent;

	//
	// The following two variables are used to keep track of window locations.
	// They are static since all instances of this class need to have access to the
	// same variables.
	//
	static int				next_x;
	static int				next_y;

	//
	// Internal routines used for the windowing system
	//
	Gopher					*gopher;

	//
	// The complete gopher information used to create this window
	//
	Response				*info;

	//
	// Routine to determine the next window location
	//
	void					compute_location(int width, int height);

	//
	// Callback for windows
	//
	static void				done_proc(Frame frame);
	static void				quit_proc(Frame frame, Event *event);

	//
	// The quit/dismiss button that every window has...
	//
	Panel_item				dir_quit;
};

#endif	_GWindow_h_

