//
// GWTelnet.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWTelnet class
//
#include "GWTelnet.h"
#include "xvgopher.h"
#include <fcntl.h>
#include <unistd.h>


//***************************************************************************
// GWTelnet::GWTelnet(Frame par)
//
GWTelnet::GWTelnet(Frame par)
{
	parent = par;
}


//***************************************************************************
// int GWTelnet::open(Response *resp)
// PURPOSE:
//   This is called when a telnet record has been received.  We need to start a
//   terminal emulator and start telnet in it (to the correct host...)
//
int GWTelnet::open(Response *resp)
{
	char	command[2000];
	char	new_title[2000];
	int		port;

	info = resp;
	if (info->get_port() == 0)
		port = 23;			// There seems to be a problem with Mark Boyns.  He didn't want to fix this in the gopher files!
	else
		port = info->get_port();
	if (*info->get_command())
		sprintf(new_title, "%s (login as %s)", info->get_title(), info->get_command());
	else
		strcpy(new_title, info->get_title());
	sprintf(command, preferences.get_telnet_command(),
				new_title,
				info->get_server(),
				port,
				info->get_type());
	system(command);
	return OK;
}


