//
// GWPref.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWPref class
//
#include "xvgopher.h"
#include "GWPref.h"
#include "Preferences.h"

GWPref	*gwpref;


//***************************************************************************
// GWPref::GWpref(Frame par)
//
GWPref::GWPref(Frame par)
{
	parent = par;
}


//***************************************************************************
// GWPref::~GWpref()
//
GWPref::~GWPref()
{
}


//***************************************************************************
// void GWPref::done_proc(Frame frame)
//   This gets called whenever a command frame is destroyed.  In the case
//   of the preferences window, we only need to hide the window.
//
void GWPref::done_proc(Frame frame)
{
	xv_set(frame,
		XV_SHOW,						FALSE,
		NULL);
}


//***************************************************************************
// int GWPref::open(Response *)
//   Create the preferences window.
//
int GWPref::open(Response *)
{
	compute_location(600, 500);
	frame = (Frame) xv_create(parent, FRAME_CMD,
		XV_X,							next_x,
		XV_Y,							next_y,
		XV_WIDTH,						447,
		XV_HEIGHT,						248,
		FRAME_LABEL,					"Preferences",
		FRAME_CMD_PIN_STATE,			FRAME_CMD_PIN_OUT,
		FRAME_SHOW_RESIZE_CORNER,		FALSE,
		XV_SHOW,						FALSE,
		FRAME_SHOW_FOOTER,				FALSE,
		FRAME_DONE_PROC,				(void (*)(Frame)) done_proc,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	panel = (Panel) xv_get(frame, FRAME_CMD_PANEL);

	int	value = preferences.get_popup_bookmarks() * 2 |
				preferences.get_remove_children();

	choices = (Panel_item) xv_create(panel, PANEL_CHECK_BOX,
		XV_X,							16,
		XV_Y,							8,
		PANEL_LAYOUT,					PANEL_VERTICAL,
		PANEL_CHOICE_STRINGS,			"Remove all child windows when parent is unpinned",
										"Popup Bookmarks at startup",
										NULL,
		PANEL_VALUE,					value,
		NULL);

	play = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							16,
		XV_Y,							76,
		PANEL_VALUE_DISPLAY_LENGTH,		30,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_LABEL_STRING,				"Sound play command:",
		NULL);
	image = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							14,
		XV_Y,							101,
		PANEL_VALUE_DISPLAY_LENGTH,		30,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_LABEL_STRING,				"Image view command:",
		NULL);
	telnet = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							48,
		XV_Y,							126,
		PANEL_VALUE_DISPLAY_LENGTH,		30,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_LABEL_STRING,				"Telnet command:",
		NULL);
	print = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							59,
		XV_Y,							151,
		PANEL_VALUE_DISPLAY_LENGTH,		30,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_LABEL_STRING,				"Print command:",
		NULL);
	mail = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							62,
		XV_Y,							176,
		PANEL_VALUE_DISPLAY_LENGTH,		30,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_LABEL_STRING,				"Mail command:",
		NULL);

	xv_create(panel, PANEL_BUTTON,
		XV_X,							197,
		XV_Y,							208,
		PANEL_LABEL_STRING,				"Apply",
		XV_KEY_DATA,					KEY_GWINDOW, this,
		PANEL_NOTIFY_PROC,				apply,
		NULL);

	return OK;
}


//***************************************************************************
// void GWPref::show()
//
void GWPref::show()
{
	xv_set(mail,
		PANEL_VALUE,					preferences.get_mail_filter(),
		NULL);
	xv_set(print,
		PANEL_VALUE,					preferences.get_print_filter(),
		NULL);
	xv_set(telnet,
		PANEL_VALUE,					preferences.get_telnet_command(),
		NULL);
	xv_set(image,
		PANEL_VALUE,					preferences.get_image_filter(),
		NULL);
	xv_set(play,
		PANEL_VALUE,					preferences.get_play_filter(),
		NULL);
	xv_set(frame,
		XV_SHOW,						TRUE,
		NULL);
}


//***************************************************************************
// void GWPref::apply(Panel_item item, Event *)
//   Read the changes made to the preferences panel and put them in our
//   database.
//
void GWPref::apply(Panel_item item, Event *)
{
	GWPref	*gw = (GWPref *) xv_get(item, XV_KEY_DATA, KEY_GWINDOW);

	int	value = (int) xv_get(gw->choices, PANEL_VALUE);
	preferences.set_remove_children(value & 1);
	preferences.set_popup_bookmarks(value & 2);

	preferences.set_mail_filter((char *) xv_get(gw->mail, PANEL_VALUE));
	preferences.set_print_filter((char *) xv_get(gw->print, PANEL_VALUE));
	preferences.set_play_filter((char *) xv_get(gw->play, PANEL_VALUE));
	preferences.set_image_filter((char *) xv_get(gw->image, PANEL_VALUE));
	preferences.set_telnet_command((char *) xv_get(gw->telnet, PANEL_VALUE));

	//
	// Finally, remove the window.
	//
	xv_set(gw->frame,
		XV_SHOW,						FALSE,
		NULL);
}


