//
// GWList.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class is a base class for any window which displays a list of gopher items.
//
#ifndef	_GWList_h_
#define	_GWList_h_

#include "GWindow.h"
#include "cursor.h"
#include "icons.h"

class GWList : public GWindow
{
public:
	//
	// Constructor
	//
							GWList();

	//
	// Window creation
	//
	int						open(Response *resp);

protected:
	//
	// Data members needed to keep track of the windowing stuff
	//
	Panel_item				dir_list;
	int						current_selected;

	//
	// Callback routines from XView.
	//
	static void				frame_event(Xv_Window, Event *, Notify_arg);
	static void				list_notify(Panel_item, char *, caddr_t, Panel_list_op, Event *, int);
	static void				show_item_info_proc(Menu menu, Menu_item mi);

	//
	// Members which are supposed to be overridden.
	//
	virtual void			row_deselect(int, Response *);
	virtual void			row_select(int, Response *);

	//
	// Utility routines
	//
	void					assign_icon(Frame);
};

#endif	_GWList_h_
