//
// GWInfo.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWInfo class
//
#include "GWInfo.h"

//***************************************************************************
// GWInfo::GWInfo(Frame par)
//
GWInfo::GWInfo(Frame par)
{
	parent = par;
}


//***************************************************************************
// int GWInfo::open(Response *resp)
//   Create a little popup which contains information about a response.
//
int GWInfo::open(Response *resp)
{
	info = resp;
	char	frame_title[2000];
	sprintf(frame_title, "Info for '%s'", info->get_title());
	compute_location(390, 180);
	frame = (Frame) xv_create(parent, FRAME_CMD,
		XV_X,							next_x,
		XV_Y,							next_y,
		XV_WIDTH,						390,
		XV_HEIGHT,						180,
		FRAME_LABEL,					frame_title,
		FRAME_CMD_PIN_STATE,			FRAME_CMD_PIN_IN,
		FRAME_SHOW_RESIZE_CORNER,		FALSE,
		XV_SHOW,						TRUE,
		FRAME_DONE_PROC,				done_proc,
		FRAME_ACCELERATOR,				'q', quit_proc, frame,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	panel = (Panel) xv_get(frame, FRAME_CMD_PANEL);

	//
	// Create the textsw in the window with the text describing the item.
	//
	char	buffer[10240];
	sprintf(buffer, "Name=%s\nType=%c\nPort=%d\nPath=%s\nHost=%s\n",
		info->get_title(),
		info->get_type(),
		info->get_port(),
		info->get_command(),
		info->get_server());
	xv_create(frame, TEXTSW,
		XV_X,							0,
		XV_Y,							0,
		XV_WIDTH,						390,
		XV_HEIGHT,						180,
		TEXTSW_CONTENTS,				buffer,
		TEXTSW_IGNORE_LIMIT,			TEXTSW_INFINITY,
		TEXTSW_READ_ONLY,				TRUE,
		NULL);

	return OK;
}

