//
// GWIndex.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWIndex class
//
#include "GWIndex.h"
#include "xvgopher.h"
#include "cursor.h"
#include <fcntl.h>
#include <unistd.h>

#define	KEY_TEXT_ITEM		20000


//***************************************************************************
// GWIndex::GWIndex(Frame par)
//
GWIndex::GWIndex(Frame par)
{
	parent = par;
}


//***************************************************************************
// Panel_setting GWIndex::index_notify(Panel_item item, Event *event)
// PURPOSE:
//   This is called whenever the user hits return on the text field.
//   When this happens, we will use the string to send to the server
//   and then we can wait for the server to send us the results of the
//   search.
//
Panel_setting GWIndex::index_notify(Panel_item item, Event *event)
{
	event = event;
	//
	// We need to build the connection and get information from it
	//
	GWIndex	*gwindow = (GWIndex *) xv_get(item, XV_KEY_DATA, KEY_GWINDOW);

	gwindow->status("Performing search...");

	//
	// Build a new command string to send to the server.  This means that we just add
	// a tab and the string in our text field to the command.
	//
	char	new_command[10000];

	Response	*r = new Response("1Results of search");
	r->set_server(gwindow->info->get_server());
	r->set_port(gwindow->info->get_port());
	sprintf(new_command, "%s\t%s",
				gwindow->info->get_command(),
				(char *) xv_get(item, PANEL_VALUE));
	r->set_command(new_command);
	GWindow *sub = CreateWindow(r, gwindow->frame);

	gwindow->status("");
	return PANEL_NONE;
}


//***************************************************************************
// int GWIndex::open(Response *resp)
// PURPOSE:
//   This will create a prompt window
//
int GWIndex::open(Response *resp)
{
	info = resp;
	char	frame_title[2000];
	sprintf(frame_title, "Index search: %s", info->get_title());
	compute_location(407, 107);
	frame = (Frame) xv_create(parent, FRAME_CMD,
		XV_X,							next_x,
		XV_Y,							next_y,
		XV_WIDTH,						407,
		XV_HEIGHT,						107,
		FRAME_LABEL,					frame_title,
		FRAME_CMD_PIN_STATE,			FRAME_CMD_PIN_IN,
		FRAME_SHOW_RESIZE_CORNER,		FALSE,
		XV_SHOW,						TRUE,
		FRAME_SHOW_FOOTER,				TRUE,
		FRAME_RIGHT_FOOTER,				info->get_server(),
		FRAME_DONE_PROC,				done_proc,
		FRAME_ACCELERATOR,				'q', quit_proc, frame,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	panel = (Panel) xv_get(frame, FRAME_CMD_PANEL);

	(Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							16,
		XV_Y,							28,
		PANEL_LABEL_STRING,				"Search for:",
		PANEL_VALUE_DISPLAY_LENGTH,		35,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_NOTIFY_PROC,				index_notify,
		XV_KEY_DATA,					KEY_FRAME,		frame,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		XV_KEY_DATA,					KEY_GOPHER,		gopher,
		NULL);

	return OK;
}

