//
// GWGopher.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWGopher class
//
#include "GWGopher.h"
#include "xvgopher.h"
#include "cursor.h"
#include <fcntl.h>
#include <unistd.h>

#define	KEY_TEXT_ITEM		20000


//***************************************************************************
// GWGopher::GWGopher(Frame par)
//
GWGopher::GWGopher(Frame par)
{
	parent = par;
}


//***************************************************************************
// int GWGopher::open(Response *)
// PURPOSE:
//   This will create a dialog window to get information about a new gopher server
//
int GWGopher::open(Response *)
{
	info = NULL;
	compute_location(407, 107);
	frame = (Frame) xv_create(parent, FRAME_CMD,
		XV_X,							next_x,
		XV_Y,							next_y,
		XV_WIDTH,						416,
		XV_HEIGHT,						128,
		FRAME_LABEL,					"Another Gopher",
		FRAME_CMD_PIN_STATE,			FRAME_CMD_PIN_OUT,
		FRAME_SHOW_RESIZE_CORNER,		FALSE,
		XV_SHOW,						TRUE,
		FRAME_SHOW_FOOTER,				FALSE,
		FRAME_DONE_PROC,				done_proc,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	panel = (Panel) xv_get(frame, FRAME_CMD_PANEL);

	//
	// Create all the panel items
	//
	server = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							32,
		XV_Y,							16,
		PANEL_LABEL_STRING,				"Server name:",
		PANEL_VALUE_DISPLAY_LENGTH,		30,
		PANEL_VALUE_STORED_LENGTH,		80,
		NULL);
	port = (Panel_item) xv_create(panel, PANEL_NUMERIC_TEXT,
		XV_X,							43,
		XV_Y,							41,
		PANEL_LABEL_STRING,				"Server port:",
		PANEL_VALUE_DISPLAY_LENGTH,		5,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_MAX_VALUE,				30000,
		PANEL_MIN_VALUE,				1,
		PANEL_VALUE,					70,
		NULL);
	xv_create(panel, PANEL_BUTTON,
		XV_X,							185,
		XV_Y,							88,
		PANEL_LABEL_STRING,				"Start",
		PANEL_NOTIFY_PROC,				start_proc,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	return OK;
}


//***************************************************************************
// void GWGopher::start_proc(Frame frame, Event *)
// PURPOS:
//   This gets called when the user presses 'q' in a window.
//
void GWGopher::start_proc(Frame frame, Event *)
{
	GWGopher	*win = (GWGopher *) xv_get(frame, XV_KEY_DATA, KEY_GWINDOW);

	int port = (int) xv_get(win->port, PANEL_VALUE);
	char *server = (char *) xv_get(win->server, PANEL_VALUE);

	Response	*r = new Response("1");
	r->set_server(server);
	r->set_port(port);
	GWindow	*main_window = CreateWindow(r, win->frame);
	if (main_window)
		main_window->open(r);

	xv_destroy_safe(frame);
}


