//
// GWFile.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWFile class
//
#include "GWFile.h"
#include "xvgopher.h"
#include "cursor.h"
#include <xview/textsw.h>

#define	KEY_TEXT_ITEM		20000
#define	KEY_TYPE			20001
#define	KEY_TEXT			20002
#define	TYPE_SAVE			1
#define	TYPE_MAIL			2


//***************************************************************************
// GWFile::GWFile(Frame par)
//
GWFile::GWFile(Frame par)
{
	parent = par;
}


//***************************************************************************
// static void menu_proc(Menu menu, Menu_item menu_item)
//
static void menu_proc(Menu menu, Menu_item menu_item)
{
	char		*str = (char *) xv_get(menu_item, MENU_STRING);
	Panel_item	txt = (Panel_item) xv_get(menu, XV_KEY_DATA, KEY_TEXT_ITEM);
	Textsw	t = (Textsw) xv_get(menu, XV_KEY_DATA, KEY_TEXT);
	char		command[200];

	if (strcmp(str, "Save...") == 0)
	{
		xv_set(txt,
			PANEL_LABEL_STRING,		"Save as:",
			XV_KEY_DATA,			KEY_TYPE,		TYPE_SAVE,
			XV_SHOW,				TRUE,
			NULL);
	}
	else if (strcmp(str, "Print") == 0)
	{
		//
		// First save the file
		//
		textsw_save(t, 0, 0);
		char name[200];
		name[0] = '\0';
		textsw_append_file_name(t, name);

		//
		// This needs to use a user definable print method!!!
		//
		sprintf(command, "%s %s &", preferences.get_print_filter(), name);
		system(command);
	}
	else if (strcmp(str, "Mail...") == 0)
	{
		xv_set(txt,
			PANEL_LABEL_STRING,		"Mail to:",
			XV_KEY_DATA,			KEY_TYPE,		TYPE_MAIL,
			XV_SHOW,				TRUE,
			NULL);
	}
}


//***************************************************************************
// static Panel_setting text_notify(Panel_item item, Event *event)
//
static Panel_setting text_notify(Panel_item item, Event *event)
{
	event = event;
	char	*string = (char *) xv_get(item, PANEL_VALUE);
	Textsw	t = (Textsw) xv_get(item, XV_KEY_DATA, KEY_TEXT);
	GWindow	*gwindow = (GWindow *) xv_get(item, XV_KEY_DATA, KEY_GWINDOW);

	switch (xv_get(item, XV_KEY_DATA, KEY_TYPE))
	{
		case TYPE_SAVE:
			gwindow->status("Saving...");
			if (textsw_store_file(t, string, 0, 0) != 0)
			{
				//
				// Some problem occured...  Notify the user
				//
				gwindow->status("Unable to save!");
			}
			else
				gwindow->status("File saved");
			break;
		case TYPE_MAIL:
		{
			textsw_save(t, 0, 0);
			char name[200];
			name[0] = '\0';

			Frame	frame = (Frame) xv_get(item, XV_KEY_DATA, KEY_FRAME);
			char	*subject = (char *) xv_get(frame, FRAME_LABEL);

			textsw_append_file_name(t, name);
			gwindow->status("Mailing...");
			char	command[200];
			sprintf(command, "%s -s '%s' %s < %s", preferences.get_mail_filter(), subject, string, name);
			system(command);
			gwindow->status("File mailed");
			break;
		}
	}
	return PANEL_NONE;
}


//***************************************************************************
// int GWFile::open(Response *resp)
// PURPOSE:
//   This will create a window in which a file will be displayed.  We will create
//   a command frame with a textsw at the bottom.  The top will be a panel with
//   a menu and a hidden text field.
//
int GWFile::open(Response *resp)
{
	info = resp;
	compute_location(600, 500);
	frame = (Frame) xv_create(parent, FRAME_CMD,
		XV_X,							next_x,
		XV_Y,							next_y,
		XV_WIDTH,						600,
		XV_HEIGHT,						500,
		FRAME_LABEL,					info->get_title(),
		FRAME_CMD_PIN_STATE,			FRAME_CMD_PIN_IN,
		FRAME_SHOW_RESIZE_CORNER,		TRUE,
		XV_SHOW,						TRUE,
		FRAME_SHOW_FOOTER,				TRUE,
		FRAME_RIGHT_FOOTER,				info->get_server(),
		FRAME_DONE_PROC,				done_proc,
		FRAME_ACCELERATOR,				'q', quit_proc, frame,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	panel = (Panel) xv_get(frame, FRAME_CMD_PANEL);
	textsw = (Textsw) xv_create(frame, TEXTSW,
		XV_X,						0,
		XV_Y,						29,
		NULL);

	//
	// Child windows have a close button
	//
	dir_quit = xv_create(panel, PANEL_BUTTON,
		XV_X,						488,	// It will be relocated anyway...
		XV_Y,						4,
		PANEL_LABEL_STRING,			"Dismiss",
		PANEL_NOTIFY_PROC,			quit_proc,
		XV_KEY_DATA,				KEY_GWINDOW, this,
		NULL);

	//
	// Create the menu and button which go in the panel...
	//
	Menu menu = (Menu) xv_create(NULL, MENU,
		MENU_NOTIFY_PROC,				menu_proc,
		MENU_STRINGS,					"Save...",
										"Print",
										"Mail...",
										NULL,
		NULL);
	xv_create(panel, PANEL_BUTTON,
		XV_X,							8,
		XV_Y,							4,
		PANEL_LABEL_STRING,				"Options",
		PANEL_ITEM_MENU,				menu,
		NULL);

	//
	// Create the text item (which will not be visible until one of the options has been
	// selected)
	//
	Panel_item txt = (Panel_item) xv_create(panel, PANEL_TEXT,
		XV_X,							128,
		XV_Y,							8,
		PANEL_LABEL_STRING,				"",
		PANEL_VALUE_DISPLAY_LENGTH,		40,
		PANEL_VALUE_STORED_LENGTH,		80,
		PANEL_NOTIFY_PROC,				text_notify,
		XV_SHOW,						FALSE,			// Invisible, initially
		XV_KEY_DATA,					KEY_FRAME,		frame,
		XV_KEY_DATA,					KEY_TEXT,		textsw,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);

	//
	// Attach the Frame to the menu so that we can see where we were created
	// when a menu option was selected.
	//
	xv_set(menu,
		XV_KEY_DATA,					KEY_FRAME,		frame,
		XV_KEY_DATA,					KEY_TEXT_ITEM,	txt,
		XV_KEY_DATA,					KEY_TEXT,		textsw,
		NULL);

	//
	// Now we need to build the connection and get information from it
	//
	frame_busy(frame);
	gopher = new Gopher(this);
	if (gopher->open(info->get_server(), info->get_port()) == NOTOK)		// Connection
		return NOTOK;
	status("Got connection, Retrieving text...");
	gopher->read(info->get_type(), info->get_command());					// Get info

	return OK;
}


//***************************************************************************
// void GWFile::display()
//
void GWFile::display()
{
	frame_unbusy(frame);
	xv_set(textsw,
		TEXTSW_FILE,			gopher->filename,
		NULL);
}


