//
// GWDirectory.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class deals with the getting and saving of ASCII files from
// a gopher server.
//
#ifndef	_GWDirectory_h_
#define	_GWDirectory_h_

#include "GWList.h"

class GWDirectory : public GWList
{
public:
							GWDirectory(Frame par);
	int						open(Response *resp);
	void					display();

protected:
	//
	// Callbacks for the XView interface
	//
#if		USE_SAVE
	static void				save_notify(Panel_item item, Event *);
#endif	USE_SAVE
	static void				menu_proc(Menu menu, Menu_item mi);

	//
	// The next two callbacks are for the menu attached to the scrolling list
	//
	static void				set_bookmark_proc(Menu menu, Menu_item mi);

	void					row_deselect(int, Response *);
	void					row_select(int, Response *);

	//
	// Various window thingies that we need to keep track of
	//
	Menu_item				bookmark_mi;
	Menu_item				show_info_mi;

	//
	// The following are used to perform certain specific tasks when creating windows.
	// They are split up to make the code more readable and modular
	//
	void					modify_list_menu();
};

#endif	_GWDirectory_h_
