//
// GWBookmarks.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class deals with bookmarks and the window that displays them.
//
#ifndef	_GWBookmarks_h_
#define	_GWBookmarks_h_

#include "GWList.h"

class GWBookmarks : public GWList
{
public:
	//
	// Constructor/Destructor
	//
							GWBookmarks(Frame);
							~GWBookmarks();

	//
	// Window creation
	//
	int						open(Response *resp);
	void					show();

	//
	// Bookmarks access
	//
	void					add(Response *r);

protected:
	void					row_deselect(int, Response *);
	void					row_select(int, Response *);

	void					read_bookmarks();
	void					write_bookmarks();

	static void				remove_bookmark_proc(Menu menu, Menu_item mi);
	static void				done_proc(Frame);

	//
	// The following are used to perform certain specific tasks when creating windows.
	// They are split up to make the code more readable and modular
	//
	void					modify_list_menu();

	Menu_item				bookmark_mi;
	Menu_item				show_info_mi;
};

extern GWBookmarks	*bookmarks;

#endif	_GWBookmarks_h_
