//
// GWAbout.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the GWAbout class
//
#include "GWAbout.h"
#include "xvgopher.h"
#include "cursor.h"
#include <fcntl.h>
#include <unistd.h>

#define	KEY_TEXT_ITEM		20000


static int			current_icon = 0;
static Panel_item	icon;


//***************************************************************************
// GWAbout::GWAbout(Frame par)
//
GWAbout::GWAbout(Frame par)
{
	parent = par;
}


//***************************************************************************
// int GWAbout::open(Response *)
// PURPOSE:
//   This will create an about window
//
int GWAbout::open(Response *)
{
	info = NULL;
	compute_location(407, 107);
	frame = (Frame) xv_create(parent, FRAME_CMD,
		XV_X,							next_x,
		XV_Y,							next_y,
		XV_WIDTH,						465,
		XV_HEIGHT,						369,
		FRAME_LABEL,					"About XvGopher",
		FRAME_CMD_PIN_STATE,			FRAME_CMD_PIN_OUT,
		FRAME_SHOW_RESIZE_CORNER,		FALSE,
		XV_SHOW,						TRUE,
		FRAME_SHOW_FOOTER,				FALSE,
		FRAME_DONE_PROC,				(void (*)(Frame)) done_proc,
		XV_KEY_DATA,					KEY_GWINDOW,	this,
		NULL);
	panel = (Panel) xv_get(frame, FRAME_CMD_PANEL);

	//
	// Interpose onto the panel so that events will generate a call
	//
	notify_interpose_event_func(panel, (Notify_func) panel_events, NOTIFY_SAFE);

	//
	// Create all the panel items
	//
	icon = (Panel_item) xv_create(panel, PANEL_MESSAGE,
		XV_X,							24,
		XV_Y,							12,
		PANEL_LABEL_IMAGE,				get_gopher(0),
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							112,
		XV_Y,							16,
		PANEL_LABEL_STRING,				"XvGopher",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							112,
		XV_Y,							39,
		PANEL_LABEL_STRING,				"Version 1.0",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							112,
		XV_Y,							62,
		PANEL_LABEL_STRING,				"(c) Copyright 1993, San Diego StateUniversity",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							20,
		XV_Y,							96,
		PANEL_LABEL_STRING,				"XvGopher was written in C++ by Andrew Scherpbier at SDSU.",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							20,
		XV_Y,							124,
		PANEL_LABEL_STRING,				"Many thanks to the following people for testing, suggestions, and beer:",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							56,
		XV_Y,							156,
		PANEL_LABEL_STRING,				"Mark Boyns",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							56,
		XV_Y,							179,
		PANEL_LABEL_STRING,				"John Denune",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							56,
		XV_Y,							202,
		PANEL_LABEL_STRING,				"Mike Halderman",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							56,
		XV_Y,							225,
		PANEL_LABEL_STRING,				"Paul Lindner",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							216,
		XV_Y,							156,
		PANEL_LABEL_STRING,				"Layout, icons, gopher chew, testing",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							216,
		XV_Y,							179,
		PANEL_LABEL_STRING,				"Testing",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							216,
		XV_Y,							202,
		PANEL_LABEL_STRING,				"Testing",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							216,
		XV_Y,							225,
		PANEL_LABEL_STRING,				"Gopher icon",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							20,
		XV_Y,							260,
		PANEL_LABEL_STRING,				"If you have comments or suggestions, please send E-Mail to:",
		PANEL_LABEL_BOLD,				FALSE,
		NULL);
	xv_create(panel, PANEL_MESSAGE,
		XV_X,							60,
		XV_Y,							292,
		PANEL_LABEL_STRING,				"xvgopher@gopher.sdsu.edu",
		PANEL_LABEL_BOLD,				TRUE,
		NULL);
	xv_create(panel, PANEL_BUTTON,
		XV_X,							201,
		XV_Y,							328,
		PANEL_LABEL_STRING,				"Dismiss",
		PANEL_NOTIFY_PROC,				dismiss_proc,
		NULL);
	return OK;
}


//***************************************************************************
// void GWAbout::dismiss_proc(Frame frame, Event *)
// PURPOS:
//   This gets called when the user presses 'q' in a window.
//
void GWAbout::dismiss_proc(Frame frame, Event *)
{
	GWindow	*win = (GWindow *) xv_get(frame, XV_KEY_DATA, KEY_GWINDOW);
	delete win;
	xv_destroy_safe(frame);
}


//***************************************************************************
// void GWAbout::done_proc(Frame frame)
// PURPOSE:
//   This gets called whenever the about window is destroyed.  We need to
//   clean up the associated GWindow structure.  Since we want all children
//   to go away as well, we will call this function recursively on our subframes.
//
void GWAbout::done_proc(Frame frame)
{
	if (!frame)
		return;
	GWindow	*win = (GWindow *) xv_get(frame, XV_KEY_DATA, KEY_GWINDOW);
	delete win;
	xv_destroy_safe(frame);
}


//***************************************************************************
// void GWAbout::panel_events(Xv_window, Event *, Notify_arg, Notify_event_type)
//
Notify_value GWAbout::panel_events(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
	current_icon ^= 1;
	xv_set(icon,
		PANEL_LABEL_IMAGE,				get_gopher(current_icon),
		NULL);
	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

